/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.VerificationAttempt;
import java.time.ZonedDateTime;

public class VerificationAttemptReader
extends Reader<VerificationAttempt> {
    private ZonedDateTime dateCreatedAfter;
    private ZonedDateTime dateCreatedBefore;
    private String channelDataTo;
    private String country;
    private VerificationAttempt.Channels channel;
    private String verifyServiceSid;
    private String verificationSid;
    private VerificationAttempt.ConversionStatus status;
    private Integer pageSize;

    public VerificationAttemptReader setDateCreatedAfter(ZonedDateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    public VerificationAttemptReader setDateCreatedBefore(ZonedDateTime dateCreatedBefore) {
        this.dateCreatedBefore = dateCreatedBefore;
        return this;
    }

    public VerificationAttemptReader setChannelDataTo(String channelDataTo) {
        this.channelDataTo = channelDataTo;
        return this;
    }

    public VerificationAttemptReader setCountry(String country) {
        this.country = country;
        return this;
    }

    public VerificationAttemptReader setChannel(VerificationAttempt.Channels channel) {
        this.channel = channel;
        return this;
    }

    public VerificationAttemptReader setVerifyServiceSid(String verifyServiceSid) {
        this.verifyServiceSid = verifyServiceSid;
        return this;
    }

    public VerificationAttemptReader setVerificationSid(String verificationSid) {
        this.verificationSid = verificationSid;
        return this;
    }

    public VerificationAttemptReader setStatus(VerificationAttempt.ConversionStatus status) {
        this.status = status;
        return this;
    }

    public VerificationAttemptReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<VerificationAttempt> read(TwilioRestClient client) {
        return new ResourceSet<VerificationAttempt>(this, client, this.firstPage(client));
    }

    @Override
    public Page<VerificationAttempt> firstPage(TwilioRestClient client) {
        String path = "/v2/Attempts";
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<VerificationAttempt> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("VerificationAttempt read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("attempts", response.getContent(), VerificationAttempt.class, client.getObjectMapper());
    }

    @Override
    public Page<VerificationAttempt> previousPage(Page<VerificationAttempt> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<VerificationAttempt> nextPage(Page<VerificationAttempt> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<VerificationAttempt> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.dateCreatedAfter != null) {
            request.addQueryParam("DateCreatedAfter", this.dateCreatedAfter.toInstant().toString());
        }
        if (this.dateCreatedBefore != null) {
            request.addQueryParam("DateCreatedBefore", this.dateCreatedBefore.toInstant().toString());
        }
        if (this.channelDataTo != null) {
            request.addQueryParam("ChannelData.To", this.channelDataTo);
        }
        if (this.country != null) {
            request.addQueryParam("Country", this.country);
        }
        if (this.channel != null) {
            request.addQueryParam("Channel", this.channel.toString());
        }
        if (this.verifyServiceSid != null) {
            request.addQueryParam("VerifyServiceSid", this.verifyServiceSid);
        }
        if (this.verificationSid != null) {
            request.addQueryParam("VerificationSid", this.verificationSid);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

