/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.VerificationAttemptFetcher;
import com.twilio.rest.verify.v2.VerificationAttemptReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VerificationAttempt
extends Resource {
    private static final long serialVersionUID = 105803800130690L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String verificationSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final ConversionStatus conversionStatus;
    private final Channels channel;
    private final Map<String, Object> price;
    private final Map<String, Object> channelData;
    private final URI url;

    public static VerificationAttemptFetcher fetcher(String pathSid) {
        return new VerificationAttemptFetcher(pathSid);
    }

    public static VerificationAttemptReader reader() {
        return new VerificationAttemptReader();
    }

    public static VerificationAttempt fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, VerificationAttempt.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static VerificationAttempt fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, VerificationAttempt.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private VerificationAttempt(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="verification_sid") String verificationSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="conversion_status") ConversionStatus conversionStatus, @JsonProperty(value="channel") Channels channel, @JsonProperty(value="price") Map<String, Object> price, @JsonProperty(value="channel_data") Map<String, Object> channelData, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.verificationSid = verificationSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.conversionStatus = conversionStatus;
        this.channel = channel;
        this.price = price;
        this.channelData = channelData;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getVerificationSid() {
        return this.verificationSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final ConversionStatus getConversionStatus() {
        return this.conversionStatus;
    }

    public final Channels getChannel() {
        return this.channel;
    }

    public final Map<String, Object> getPrice() {
        return this.price;
    }

    public final Map<String, Object> getChannelData() {
        return this.channelData;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationAttempt other = (VerificationAttempt)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.verificationSid, other.verificationSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals((Object)this.conversionStatus, (Object)other.conversionStatus) && Objects.equals((Object)this.channel, (Object)other.channel) && Objects.equals(this.price, other.price) && Objects.equals(this.channelData, other.channelData) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.verificationSid, this.dateCreated, this.dateUpdated, this.conversionStatus, this.channel, this.price, this.channelData, this.url});
    }

    public String toString() {
        return "VerificationAttempt(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", verificationSid=" + this.getVerificationSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", conversionStatus=" + (Object)((Object)this.getConversionStatus()) + ", channel=" + (Object)((Object)this.getChannel()) + ", price=" + this.getPrice() + ", channelData=" + this.getChannelData() + ", url=" + this.getUrl() + ")";
    }

    public static enum Channels {
        SMS("sms"),
        CALL("call"),
        EMAIL("email"),
        WHATSAPP("whatsapp");

        private final String value;

        private Channels(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Channels forValue(String value) {
            return (Channels)Promoter.enumFromString((String)value, (Enum[])Channels.values());
        }
    }

    public static enum ConversionStatus {
        CONVERTED("converted"),
        UNCONVERTED("unconverted");

        private final String value;

        private ConversionStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ConversionStatus forValue(String value) {
            return (ConversionStatus)Promoter.enumFromString((String)value, (Enum[])ConversionStatus.values());
        }
    }
}

