/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.Template;

public class TemplateReader
extends Reader<Template> {
    private String friendlyName;
    private Integer pageSize;

    public TemplateReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TemplateReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Template> read(TwilioRestClient client) {
        return new ResourceSet<Template>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Template> firstPage(TwilioRestClient client) {
        String path = "/v2/Templates";
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Template> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Template read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("templates", response.getContent(), Template.class, client.getObjectMapper());
    }

    @Override
    public Page<Template> previousPage(Page<Template> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Template> nextPage(Page<Template> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Template> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

