/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.Form;

public class FormFetcher
extends Fetcher<Form> {
    private Form.FormTypes formType;

    public FormFetcher(Form.FormTypes formType) {
        this.formType = formType;
    }

    @Override
    public Form fetch(TwilioRestClient client) {
        String path = "/v2/Forms/{FormType}";
        path = path.replace("{FormType}", this.formType.toString());
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Form fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Form.fromJson(response.getStream(), client.getObjectMapper());
    }
}

