/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.trustproducts;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsEvaluations;

public class TrustProductsEvaluationsCreator
extends Creator<TrustProductsEvaluations> {
    private String pathTrustProductSid;
    private String policySid;

    public TrustProductsEvaluationsCreator(String pathTrustProductSid, String policySid) {
        this.pathTrustProductSid = pathTrustProductSid;
        this.policySid = policySid;
    }

    public TrustProductsEvaluationsCreator setPolicySid(String policySid) {
        this.policySid = policySid;
        return this;
    }

    @Override
    public TrustProductsEvaluations create(TwilioRestClient client) {
        String path = "/v1/TrustProducts/{TrustProductSid}/Evaluations";
        path = path.replace("{TrustProductSid}", this.pathTrustProductSid.toString());
        path = path.replace("{PolicySid}", this.policySid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUSTHUB.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TrustProductsEvaluations creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return TrustProductsEvaluations.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.policySid != null) {
            request.addPostParam("PolicySid", this.policySid);
        }
    }
}

