/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.trustproducts;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsEntityAssignments;

public class TrustProductsEntityAssignmentsFetcher
extends Fetcher<TrustProductsEntityAssignments> {
    private String pathTrustProductSid;
    private String pathSid;

    public TrustProductsEntityAssignmentsFetcher(String pathTrustProductSid, String pathSid) {
        this.pathTrustProductSid = pathTrustProductSid;
        this.pathSid = pathSid;
    }

    @Override
    public TrustProductsEntityAssignments fetch(TwilioRestClient client) {
        String path = "/v1/TrustProducts/{TrustProductSid}/EntityAssignments/{Sid}";
        path = path.replace("{TrustProductSid}", this.pathTrustProductSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TRUSTHUB.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TrustProductsEntityAssignments fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return TrustProductsEntityAssignments.fromJson(response.getStream(), client.getObjectMapper());
    }
}

