/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.trustproducts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsEntityAssignmentsCreator;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsEntityAssignmentsDeleter;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsEntityAssignmentsFetcher;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsEntityAssignmentsReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TrustProductsEntityAssignments
extends Resource {
    private static final long serialVersionUID = 11655766001892L;
    private final String sid;
    private final String trustProductSid;
    private final String accountSid;
    private final String objectSid;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static TrustProductsEntityAssignmentsCreator creator(String pathTrustProductSid, String objectSid) {
        return new TrustProductsEntityAssignmentsCreator(pathTrustProductSid, objectSid);
    }

    public static TrustProductsEntityAssignmentsDeleter deleter(String pathTrustProductSid, String pathSid) {
        return new TrustProductsEntityAssignmentsDeleter(pathTrustProductSid, pathSid);
    }

    public static TrustProductsEntityAssignmentsFetcher fetcher(String pathTrustProductSid, String pathSid) {
        return new TrustProductsEntityAssignmentsFetcher(pathTrustProductSid, pathSid);
    }

    public static TrustProductsEntityAssignmentsReader reader(String pathTrustProductSid) {
        return new TrustProductsEntityAssignmentsReader(pathTrustProductSid);
    }

    public static TrustProductsEntityAssignments fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TrustProductsEntityAssignments.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TrustProductsEntityAssignments fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TrustProductsEntityAssignments.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TrustProductsEntityAssignments(@JsonProperty(value="sid") String sid, @JsonProperty(value="trust_product_sid") String trustProductSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="object_sid") String objectSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.trustProductSid = trustProductSid;
        this.accountSid = accountSid;
        this.objectSid = objectSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTrustProductSid() {
        return this.trustProductSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getObjectSid() {
        return this.objectSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustProductsEntityAssignments other = (TrustProductsEntityAssignments)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.trustProductSid, other.trustProductSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.objectSid, other.objectSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.trustProductSid, this.accountSid, this.objectSid, this.dateCreated, this.url);
    }

    public String toString() {
        return "TrustProductsEntityAssignments(sid=" + this.getSid() + ", trustProductSid=" + this.getTrustProductSid() + ", accountSid=" + this.getAccountSid() + ", objectSid=" + this.getObjectSid() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }
}

