/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.customerprofiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesEvaluationsCreator;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesEvaluationsFetcher;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesEvaluationsReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CustomerProfilesEvaluations
extends Resource {
    private static final long serialVersionUID = 45516903020077L;
    private final String sid;
    private final String accountSid;
    private final String policySid;
    private final String customerProfileSid;
    private final Status status;
    private final List<Map<String, Object>> results;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static CustomerProfilesEvaluationsCreator creator(String pathCustomerProfileSid, String policySid) {
        return new CustomerProfilesEvaluationsCreator(pathCustomerProfileSid, policySid);
    }

    public static CustomerProfilesEvaluationsFetcher fetcher(String pathCustomerProfileSid, String pathSid) {
        return new CustomerProfilesEvaluationsFetcher(pathCustomerProfileSid, pathSid);
    }

    public static CustomerProfilesEvaluationsReader reader(String pathCustomerProfileSid) {
        return new CustomerProfilesEvaluationsReader(pathCustomerProfileSid);
    }

    public static CustomerProfilesEvaluations fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CustomerProfilesEvaluations.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CustomerProfilesEvaluations fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CustomerProfilesEvaluations.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CustomerProfilesEvaluations(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="policy_sid") String policySid, @JsonProperty(value="customer_profile_sid") String customerProfileSid, @JsonProperty(value="status") Status status, @JsonProperty(value="results") List<Map<String, Object>> results, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.policySid = policySid;
        this.customerProfileSid = customerProfileSid;
        this.status = status;
        this.results = results;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getPolicySid() {
        return this.policySid;
    }

    public final String getCustomerProfileSid() {
        return this.customerProfileSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final List<Map<String, Object>> getResults() {
        return this.results;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerProfilesEvaluations other = (CustomerProfilesEvaluations)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.policySid, other.policySid) && Objects.equals(this.customerProfileSid, other.customerProfileSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.results, other.results) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.policySid, this.customerProfileSid, this.status, this.results, this.dateCreated, this.url});
    }

    public String toString() {
        return "CustomerProfilesEvaluations(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", policySid=" + this.getPolicySid() + ", customerProfileSid=" + this.getCustomerProfileSid() + ", status=" + (Object)((Object)this.getStatus()) + ", results=" + this.getResults() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Status {
        COMPLIANT("compliant"),
        NONCOMPLIANT("noncompliant");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

