/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.customerprofiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesEntityAssignmentsCreator;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesEntityAssignmentsDeleter;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesEntityAssignmentsFetcher;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesEntityAssignmentsReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CustomerProfilesEntityAssignments
extends Resource {
    private static final long serialVersionUID = 178139363614511L;
    private final String sid;
    private final String customerProfileSid;
    private final String accountSid;
    private final String objectSid;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static CustomerProfilesEntityAssignmentsCreator creator(String pathCustomerProfileSid, String objectSid) {
        return new CustomerProfilesEntityAssignmentsCreator(pathCustomerProfileSid, objectSid);
    }

    public static CustomerProfilesEntityAssignmentsDeleter deleter(String pathCustomerProfileSid, String pathSid) {
        return new CustomerProfilesEntityAssignmentsDeleter(pathCustomerProfileSid, pathSid);
    }

    public static CustomerProfilesEntityAssignmentsFetcher fetcher(String pathCustomerProfileSid, String pathSid) {
        return new CustomerProfilesEntityAssignmentsFetcher(pathCustomerProfileSid, pathSid);
    }

    public static CustomerProfilesEntityAssignmentsReader reader(String pathCustomerProfileSid) {
        return new CustomerProfilesEntityAssignmentsReader(pathCustomerProfileSid);
    }

    public static CustomerProfilesEntityAssignments fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CustomerProfilesEntityAssignments.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CustomerProfilesEntityAssignments fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CustomerProfilesEntityAssignments.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CustomerProfilesEntityAssignments(@JsonProperty(value="sid") String sid, @JsonProperty(value="customer_profile_sid") String customerProfileSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="object_sid") String objectSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.customerProfileSid = customerProfileSid;
        this.accountSid = accountSid;
        this.objectSid = objectSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getCustomerProfileSid() {
        return this.customerProfileSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getObjectSid() {
        return this.objectSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerProfilesEntityAssignments other = (CustomerProfilesEntityAssignments)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.customerProfileSid, other.customerProfileSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.objectSid, other.objectSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.customerProfileSid, this.accountSid, this.objectSid, this.dateCreated, this.url);
    }

    public String toString() {
        return "CustomerProfilesEntityAssignments(sid=" + this.getSid() + ", customerProfileSid=" + this.getCustomerProfileSid() + ", accountSid=" + this.getAccountSid() + ", objectSid=" + this.getObjectSid() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }
}

