/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.TrustProducts;
import java.net.URI;

public class TrustProductsCreator
extends Creator<TrustProducts> {
    private String friendlyName;
    private String email;
    private String policySid;
    private URI statusCallback;

    public TrustProductsCreator(String friendlyName, String email, String policySid) {
        this.friendlyName = friendlyName;
        this.email = email;
        this.policySid = policySid;
    }

    public TrustProductsCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TrustProductsCreator setEmail(String email) {
        this.email = email;
        return this;
    }

    public TrustProductsCreator setPolicySid(String policySid) {
        this.policySid = policySid;
        return this;
    }

    public TrustProductsCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public TrustProductsCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    @Override
    public TrustProducts create(TwilioRestClient client) {
        String path = "/v1/TrustProducts";
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        path = path.replace("{Email}", this.email.toString());
        path = path.replace("{PolicySid}", this.policySid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUSTHUB.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TrustProducts creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return TrustProducts.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.email != null) {
            request.addPostParam("Email", this.email);
        }
        if (this.policySid != null) {
            request.addPostParam("PolicySid", this.policySid);
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
    }
}

