/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.EndUserCreator;
import com.twilio.rest.trusthub.v1.EndUserDeleter;
import com.twilio.rest.trusthub.v1.EndUserFetcher;
import com.twilio.rest.trusthub.v1.EndUserReader;
import com.twilio.rest.trusthub.v1.EndUserUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndUser
extends Resource {
    private static final long serialVersionUID = 90504447987573L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final String type;
    private final Map<String, Object> attributes;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static EndUserCreator creator(String friendlyName, String type) {
        return new EndUserCreator(friendlyName, type);
    }

    public static EndUserDeleter deleter(String pathSid) {
        return new EndUserDeleter(pathSid);
    }

    public static EndUserFetcher fetcher(String pathSid) {
        return new EndUserFetcher(pathSid);
    }

    public static EndUserReader reader() {
        return new EndUserReader();
    }

    public static EndUserUpdater updater(String pathSid) {
        return new EndUserUpdater(pathSid);
    }

    public static EndUser fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, EndUser.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static EndUser fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, EndUser.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private EndUser(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="type") String type, @JsonProperty(value="attributes") Map<String, Object> attributes, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.type = type;
        this.attributes = attributes;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getType() {
        return this.type;
    }

    public final Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndUser other = (EndUser)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.type, other.type) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.friendlyName, this.type, this.attributes, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return "EndUser(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", type=" + this.getType() + ", attributes=" + this.getAttributes() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }
}

