/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.ComplianceInquiries;

public class ComplianceInquiriesCreator
extends Creator<ComplianceInquiries> {
    private String primaryProfileSid;
    private String notificationEmail;

    public ComplianceInquiriesCreator(String primaryProfileSid) {
        this.primaryProfileSid = primaryProfileSid;
    }

    public ComplianceInquiriesCreator setPrimaryProfileSid(String primaryProfileSid) {
        this.primaryProfileSid = primaryProfileSid;
        return this;
    }

    public ComplianceInquiriesCreator setNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
        return this;
    }

    @Override
    public ComplianceInquiries create(TwilioRestClient client) {
        String path = "/v1/ComplianceInquiries/Customers/Initialize";
        path = path.replace("{PrimaryProfileSid}", this.primaryProfileSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUSTHUB.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ComplianceInquiries creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ComplianceInquiries.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.primaryProfileSid != null) {
            request.addPostParam("PrimaryProfileSid", this.primaryProfileSid);
        }
        if (this.notificationEmail != null) {
            request.addPostParam("NotificationEmail", this.notificationEmail);
        }
    }
}

