/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.ComplianceInquiriesCreator;
import com.twilio.rest.trusthub.v1.ComplianceInquiriesUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ComplianceInquiries
extends Resource {
    private static final long serialVersionUID = 107785038422599L;
    private final String inquiryId;
    private final String inquirySessionToken;
    private final String customerId;
    private final URI url;

    public static ComplianceInquiriesCreator creator(String primaryProfileSid) {
        return new ComplianceInquiriesCreator(primaryProfileSid);
    }

    public static ComplianceInquiriesUpdater updater(String pathCustomerId, String primaryProfileSid) {
        return new ComplianceInquiriesUpdater(pathCustomerId, primaryProfileSid);
    }

    public static ComplianceInquiries fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ComplianceInquiries.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ComplianceInquiries fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ComplianceInquiries.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ComplianceInquiries(@JsonProperty(value="inquiry_id") String inquiryId, @JsonProperty(value="inquiry_session_token") String inquirySessionToken, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="url") URI url) {
        this.inquiryId = inquiryId;
        this.inquirySessionToken = inquirySessionToken;
        this.customerId = customerId;
        this.url = url;
    }

    public final String getInquiryId() {
        return this.inquiryId;
    }

    public final String getInquirySessionToken() {
        return this.inquirySessionToken;
    }

    public final String getCustomerId() {
        return this.customerId;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplianceInquiries other = (ComplianceInquiries)o;
        return Objects.equals(this.inquiryId, other.inquiryId) && Objects.equals(this.inquirySessionToken, other.inquirySessionToken) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.inquiryId, this.inquirySessionToken, this.customerId, this.url);
    }

    public String toString() {
        return "ComplianceInquiries(inquiryId=" + this.getInquiryId() + ", inquirySessionToken=" + this.getInquirySessionToken() + ", customerId=" + this.getCustomerId() + ", url=" + this.getUrl() + ")";
    }
}

