/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.trunk.CredentialList;

public class CredentialListFetcher
extends Fetcher<CredentialList> {
    private String pathTrunkSid;
    private String pathSid;

    public CredentialListFetcher(String pathTrunkSid, String pathSid) {
        this.pathTrunkSid = pathTrunkSid;
        this.pathSid = pathSid;
    }

    @Override
    public CredentialList fetch(TwilioRestClient client) {
        String path = "/v1/Trunks/{TrunkSid}/CredentialLists/{Sid}";
        path = path.replace("{TrunkSid}", this.pathTrunkSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TRUNKING.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CredentialList fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return CredentialList.fromJson(response.getStream(), client.getObjectMapper());
    }
}

