/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.taskqueue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.taskqueue.TaskQueueBulkRealTimeStatisticsCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskQueueBulkRealTimeStatistics
extends Resource {
    private static final long serialVersionUID = 187525220896144L;
    private final String accountSid;
    private final String workspaceSid;
    private final List<Map<String, Object>> taskQueueData;
    private final Integer taskQueueResponseCount;
    private final URI url;

    public static TaskQueueBulkRealTimeStatisticsCreator creator(String pathWorkspaceSid) {
        return new TaskQueueBulkRealTimeStatisticsCreator(pathWorkspaceSid);
    }

    public static TaskQueueBulkRealTimeStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TaskQueueBulkRealTimeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TaskQueueBulkRealTimeStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TaskQueueBulkRealTimeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TaskQueueBulkRealTimeStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="task_queue_data") List<Map<String, Object>> taskQueueData, @JsonProperty(value="task_queue_response_count") Integer taskQueueResponseCount, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.workspaceSid = workspaceSid;
        this.taskQueueData = taskQueueData;
        this.taskQueueResponseCount = taskQueueResponseCount;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final List<Map<String, Object>> getTaskQueueData() {
        return this.taskQueueData;
    }

    public final Integer getTaskQueueResponseCount() {
        return this.taskQueueResponseCount;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskQueueBulkRealTimeStatistics other = (TaskQueueBulkRealTimeStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.taskQueueData, other.taskQueueData) && Objects.equals(this.taskQueueResponseCount, other.taskQueueResponseCount) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.workspaceSid, this.taskQueueData, this.taskQueueResponseCount, this.url);
    }

    public String toString() {
        return "TaskQueueBulkRealTimeStatistics(accountSid=" + this.getAccountSid() + ", workspaceSid=" + this.getWorkspaceSid() + ", taskQueueData=" + this.getTaskQueueData() + ", taskQueueResponseCount=" + this.getTaskQueueResponseCount() + ", url=" + this.getUrl() + ")";
    }
}

