/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.TaskChannel;

public class TaskChannelReader
extends Reader<TaskChannel> {
    private String pathWorkspaceSid;
    private Integer pageSize;

    public TaskChannelReader(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public TaskChannelReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<TaskChannel> read(TwilioRestClient client) {
        return new ResourceSet<TaskChannel>(this, client, this.firstPage(client));
    }

    @Override
    public Page<TaskChannel> firstPage(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/TaskChannels";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<TaskChannel> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskChannel read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("channels", response.getContent(), TaskChannel.class, client.getObjectMapper());
    }

    @Override
    public Page<TaskChannel> previousPage(Page<TaskChannel> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TASKROUTER.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TaskChannel> nextPage(Page<TaskChannel> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TASKROUTER.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TaskChannel> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

