/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.syncstream;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.syncstream.StreamMessage;
import java.util.Map;

public class StreamMessageCreator
extends Creator<StreamMessage> {
    private String pathServiceSid;
    private String pathStreamSid;
    private Map<String, Object> data;

    public StreamMessageCreator(String pathServiceSid, String pathStreamSid, Map<String, Object> data) {
        this.pathServiceSid = pathServiceSid;
        this.pathStreamSid = pathStreamSid;
        this.data = data;
    }

    public StreamMessageCreator setData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    @Override
    public StreamMessage create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Streams/{StreamSid}/Messages";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{StreamSid}", this.pathStreamSid.toString());
        path = path.replace("{Data}", this.data.toString());
        Request request = new Request(HttpMethod.POST, Domains.SYNC.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("StreamMessage creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return StreamMessage.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.data != null) {
            request.addPostParam("Data", Converter.mapToJson(this.data));
        }
    }
}

