/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.syncmap;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.syncmap.SyncMapItem;

public class SyncMapItemReader
extends Reader<SyncMapItem> {
    private String pathServiceSid;
    private String pathMapSid;
    private SyncMapItem.QueryResultOrder order;
    private String from;
    private SyncMapItem.QueryFromBoundType bounds;
    private Integer pageSize;

    public SyncMapItemReader(String pathServiceSid, String pathMapSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathMapSid = pathMapSid;
    }

    public SyncMapItemReader setOrder(SyncMapItem.QueryResultOrder order) {
        this.order = order;
        return this;
    }

    public SyncMapItemReader setFrom(String from) {
        this.from = from;
        return this;
    }

    public SyncMapItemReader setBounds(SyncMapItem.QueryFromBoundType bounds) {
        this.bounds = bounds;
        return this;
    }

    public SyncMapItemReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<SyncMapItem> read(TwilioRestClient client) {
        return new ResourceSet<SyncMapItem>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SyncMapItem> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Maps/{MapSid}/Items";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{MapSid}", this.pathMapSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.SYNC.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<SyncMapItem> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncMapItem read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("items", response.getContent(), SyncMapItem.class, client.getObjectMapper());
    }

    @Override
    public Page<SyncMapItem> previousPage(Page<SyncMapItem> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SYNC.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncMapItem> nextPage(Page<SyncMapItem> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SYNC.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncMapItem> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.order != null) {
            request.addQueryParam("Order", this.order.toString());
        }
        if (this.from != null) {
            request.addQueryParam("From", this.from);
        }
        if (this.bounds != null) {
            request.addQueryParam("Bounds", this.bounds.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

