/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.synclist;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.sync.v1.service.synclist.SyncListPermissionDeleter;
import com.twilio.rest.sync.v1.service.synclist.SyncListPermissionFetcher;
import com.twilio.rest.sync.v1.service.synclist.SyncListPermissionReader;
import com.twilio.rest.sync.v1.service.synclist.SyncListPermissionUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SyncListPermission
extends Resource {
    private static final long serialVersionUID = 225550881347017L;
    private final String accountSid;
    private final String serviceSid;
    private final String listSid;
    private final String identity;
    private final Boolean read;
    private final Boolean write;
    private final Boolean manage;
    private final URI url;

    public static SyncListPermissionDeleter deleter(String pathServiceSid, String pathListSid, String pathIdentity) {
        return new SyncListPermissionDeleter(pathServiceSid, pathListSid, pathIdentity);
    }

    public static SyncListPermissionFetcher fetcher(String pathServiceSid, String pathListSid, String pathIdentity) {
        return new SyncListPermissionFetcher(pathServiceSid, pathListSid, pathIdentity);
    }

    public static SyncListPermissionReader reader(String pathServiceSid, String pathListSid) {
        return new SyncListPermissionReader(pathServiceSid, pathListSid);
    }

    public static SyncListPermissionUpdater updater(String pathServiceSid, String pathListSid, String pathIdentity, Boolean read, Boolean write, Boolean manage) {
        return new SyncListPermissionUpdater(pathServiceSid, pathListSid, pathIdentity, read, write, manage);
    }

    public static SyncListPermission fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SyncListPermission.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SyncListPermission fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SyncListPermission.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SyncListPermission(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="list_sid") String listSid, @JsonProperty(value="identity") String identity, @JsonProperty(value="read") Boolean read, @JsonProperty(value="write") Boolean write, @JsonProperty(value="manage") Boolean manage, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.listSid = listSid;
        this.identity = identity;
        this.read = read;
        this.write = write;
        this.manage = manage;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getListSid() {
        return this.listSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final Boolean getRead() {
        return this.read;
    }

    public final Boolean getWrite() {
        return this.write;
    }

    public final Boolean getManage() {
        return this.manage;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncListPermission other = (SyncListPermission)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.listSid, other.listSid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.read, other.read) && Objects.equals(this.write, other.write) && Objects.equals(this.manage, other.manage) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.serviceSid, this.listSid, this.identity, this.read, this.write, this.manage, this.url);
    }

    public String toString() {
        return "SyncListPermission(accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", listSid=" + this.getListSid() + ", identity=" + this.getIdentity() + ", read=" + this.getRead() + ", write=" + this.getWrite() + ", manage=" + this.getManage() + ", url=" + this.getUrl() + ")";
    }
}

