/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.synclist;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.synclist.SyncListItem;
import java.util.Map;

public class SyncListItemCreator
extends Creator<SyncListItem> {
    private String pathServiceSid;
    private String pathListSid;
    private Map<String, Object> data;
    private Integer ttl;
    private Integer itemTtl;
    private Integer collectionTtl;

    public SyncListItemCreator(String pathServiceSid, String pathListSid, Map<String, Object> data) {
        this.pathServiceSid = pathServiceSid;
        this.pathListSid = pathListSid;
        this.data = data;
    }

    public SyncListItemCreator setData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public SyncListItemCreator setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public SyncListItemCreator setItemTtl(Integer itemTtl) {
        this.itemTtl = itemTtl;
        return this;
    }

    public SyncListItemCreator setCollectionTtl(Integer collectionTtl) {
        this.collectionTtl = collectionTtl;
        return this;
    }

    @Override
    public SyncListItem create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Lists/{ListSid}/Items";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{ListSid}", this.pathListSid.toString());
        path = path.replace("{Data}", this.data.toString());
        Request request = new Request(HttpMethod.POST, Domains.SYNC.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncListItem creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SyncListItem.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.data != null) {
            request.addPostParam("Data", Converter.mapToJson(this.data));
        }
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
        if (this.itemTtl != null) {
            request.addPostParam("ItemTtl", this.itemTtl.toString());
        }
        if (this.collectionTtl != null) {
            request.addPostParam("CollectionTtl", this.collectionTtl.toString());
        }
    }
}

