/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.SyncStream;

public class SyncStreamCreator
extends Creator<SyncStream> {
    private String pathServiceSid;
    private String uniqueName;
    private Integer ttl;

    public SyncStreamCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public SyncStreamCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public SyncStreamCreator setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public SyncStream create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Streams";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.SYNC.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncStream creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SyncStream.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
    }
}

