/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.SyncMap;

public class SyncMapReader
extends Reader<SyncMap> {
    private String pathServiceSid;
    private Integer pageSize;

    public SyncMapReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public SyncMapReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<SyncMap> read(TwilioRestClient client) {
        return new ResourceSet<SyncMap>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SyncMap> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Maps";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.SYNC.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<SyncMap> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncMap read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("maps", response.getContent(), SyncMap.class, client.getObjectMapper());
    }

    @Override
    public Page<SyncMap> previousPage(Page<SyncMap> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SYNC.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncMap> nextPage(Page<SyncMap> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SYNC.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncMap> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

