/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.Service;
import java.net.URI;

public class ServiceUpdater
extends Updater<Service> {
    private String pathSid;
    private URI webhookUrl;
    private String friendlyName;
    private Boolean reachabilityWebhooksEnabled;
    private Boolean aclEnabled;
    private Boolean reachabilityDebouncingEnabled;
    private Integer reachabilityDebouncingWindow;
    private Boolean webhooksFromRestEnabled;

    public ServiceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ServiceUpdater setWebhookUrl(URI webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    public ServiceUpdater setWebhookUrl(String webhookUrl) {
        return this.setWebhookUrl(Promoter.uriFromString(webhookUrl));
    }

    public ServiceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceUpdater setReachabilityWebhooksEnabled(Boolean reachabilityWebhooksEnabled) {
        this.reachabilityWebhooksEnabled = reachabilityWebhooksEnabled;
        return this;
    }

    public ServiceUpdater setAclEnabled(Boolean aclEnabled) {
        this.aclEnabled = aclEnabled;
        return this;
    }

    public ServiceUpdater setReachabilityDebouncingEnabled(Boolean reachabilityDebouncingEnabled) {
        this.reachabilityDebouncingEnabled = reachabilityDebouncingEnabled;
        return this;
    }

    public ServiceUpdater setReachabilityDebouncingWindow(Integer reachabilityDebouncingWindow) {
        this.reachabilityDebouncingWindow = reachabilityDebouncingWindow;
        return this;
    }

    public ServiceUpdater setWebhooksFromRestEnabled(Boolean webhooksFromRestEnabled) {
        this.webhooksFromRestEnabled = webhooksFromRestEnabled;
        return this;
    }

    @Override
    public Service update(TwilioRestClient client) {
        String path = "/v1/Services/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.SYNC.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.webhookUrl != null) {
            request.addPostParam("WebhookUrl", this.webhookUrl.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.reachabilityWebhooksEnabled != null) {
            request.addPostParam("ReachabilityWebhooksEnabled", this.reachabilityWebhooksEnabled.toString());
        }
        if (this.aclEnabled != null) {
            request.addPostParam("AclEnabled", this.aclEnabled.toString());
        }
        if (this.reachabilityDebouncingEnabled != null) {
            request.addPostParam("ReachabilityDebouncingEnabled", this.reachabilityDebouncingEnabled.toString());
        }
        if (this.reachabilityDebouncingWindow != null) {
            request.addPostParam("ReachabilityDebouncingWindow", this.reachabilityDebouncingWindow.toString());
        }
        if (this.webhooksFromRestEnabled != null) {
            request.addPostParam("WebhooksFromRestEnabled", this.webhooksFromRestEnabled.toString());
        }
    }
}

