/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.UsageRecordReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UsageRecord
extends Resource {
    private static final long serialVersionUID = 269766941607639L;
    private final String accountSid;
    private final String simSid;
    private final String networkSid;
    private final String fleetSid;
    private final String isoCountry;
    private final Map<String, Object> period;
    private final Long dataUpload;
    private final Long dataDownload;
    private final Long dataTotal;
    private final BigDecimal dataTotalBilled;
    private final Currency billedUnit;

    public static UsageRecordReader reader() {
        return new UsageRecordReader();
    }

    public static UsageRecord fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UsageRecord.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static UsageRecord fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UsageRecord.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private UsageRecord(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="network_sid") String networkSid, @JsonProperty(value="fleet_sid") String fleetSid, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="period") Map<String, Object> period, @JsonProperty(value="data_upload") Long dataUpload, @JsonProperty(value="data_download") Long dataDownload, @JsonProperty(value="data_total") Long dataTotal, @JsonProperty(value="data_total_billed") BigDecimal dataTotalBilled, @JsonProperty(value="billed_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency billedUnit) {
        this.accountSid = accountSid;
        this.simSid = simSid;
        this.networkSid = networkSid;
        this.fleetSid = fleetSid;
        this.isoCountry = isoCountry;
        this.period = period;
        this.dataUpload = dataUpload;
        this.dataDownload = dataDownload;
        this.dataTotal = dataTotal;
        this.dataTotalBilled = dataTotalBilled;
        this.billedUnit = billedUnit;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final String getNetworkSid() {
        return this.networkSid;
    }

    public final String getFleetSid() {
        return this.fleetSid;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final Map<String, Object> getPeriod() {
        return this.period;
    }

    public final Long getDataUpload() {
        return this.dataUpload;
    }

    public final Long getDataDownload() {
        return this.dataDownload;
    }

    public final Long getDataTotal() {
        return this.dataTotal;
    }

    public final BigDecimal getDataTotalBilled() {
        return this.dataTotalBilled;
    }

    public final Currency getBilledUnit() {
        return this.billedUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageRecord other = (UsageRecord)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.simSid, other.simSid) && Objects.equals(this.networkSid, other.networkSid) && Objects.equals(this.fleetSid, other.fleetSid) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.period, other.period) && Objects.equals(this.dataUpload, other.dataUpload) && Objects.equals(this.dataDownload, other.dataDownload) && Objects.equals(this.dataTotal, other.dataTotal) && Objects.equals(this.dataTotalBilled, other.dataTotalBilled) && Objects.equals(this.billedUnit, other.billedUnit);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.simSid, this.networkSid, this.fleetSid, this.isoCountry, this.period, this.dataUpload, this.dataDownload, this.dataTotal, this.dataTotalBilled, this.billedUnit);
    }

    public String toString() {
        return "UsageRecord(accountSid=" + this.getAccountSid() + ", simSid=" + this.getSimSid() + ", networkSid=" + this.getNetworkSid() + ", fleetSid=" + this.getFleetSid() + ", isoCountry=" + this.getIsoCountry() + ", period=" + this.getPeriod() + ", dataUpload=" + this.getDataUpload() + ", dataDownload=" + this.getDataDownload() + ", dataTotal=" + this.getDataTotal() + ", dataTotalBilled=" + this.getDataTotalBilled() + ", billedUnit=" + this.getBilledUnit() + ")";
    }

    public static enum Group {
        SIM("sim"),
        FLEET("fleet"),
        NETWORK("network"),
        ISOCOUNTRY("isoCountry");

        private final String value;

        private Group(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Group forValue(String value) {
            return (Group)Promoter.enumFromString((String)value, (Enum[])Group.values());
        }
    }

    public static enum Granularity {
        HOUR("hour"),
        DAY("day"),
        ALL("all");

        private final String value;

        private Granularity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Granularity forValue(String value) {
            return (Granularity)Promoter.enumFromString((String)value, (Enum[])Granularity.values());
        }
    }
}

