/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.SmsCommand;

public class SmsCommandReader
extends Reader<SmsCommand> {
    private String sim;
    private SmsCommand.Status status;
    private SmsCommand.Direction direction;
    private Integer pageSize;

    public SmsCommandReader setSim(String sim) {
        this.sim = sim;
        return this;
    }

    public SmsCommandReader setStatus(SmsCommand.Status status) {
        this.status = status;
        return this;
    }

    public SmsCommandReader setDirection(SmsCommand.Direction direction) {
        this.direction = direction;
        return this;
    }

    public SmsCommandReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<SmsCommand> read(TwilioRestClient client) {
        return new ResourceSet<SmsCommand>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SmsCommand> firstPage(TwilioRestClient client) {
        String path = "/v1/SmsCommands";
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<SmsCommand> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SmsCommand read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("sms_commands", response.getContent(), SmsCommand.class, client.getObjectMapper());
    }

    @Override
    public Page<SmsCommand> previousPage(Page<SmsCommand> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SmsCommand> nextPage(Page<SmsCommand> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SmsCommand> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.sim != null) {
            request.addQueryParam("Sim", this.sim);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.direction != null) {
            request.addQueryParam("Direction", this.direction.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

