/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.NetworkAccessProfile;
import java.util.List;

public class NetworkAccessProfileCreator
extends Creator<NetworkAccessProfile> {
    private String uniqueName;
    private List<String> networks;

    public NetworkAccessProfileCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public NetworkAccessProfileCreator setNetworks(List<String> networks) {
        this.networks = networks;
        return this;
    }

    public NetworkAccessProfileCreator setNetworks(String networks) {
        return this.setNetworks(Promoter.listOfOne(networks));
    }

    @Override
    public NetworkAccessProfile create(TwilioRestClient client) {
        String path = "/v1/NetworkAccessProfiles";
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("NetworkAccessProfile creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return NetworkAccessProfile.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.networks != null) {
            for (String prop : this.networks) {
                request.addPostParam("Networks", prop);
            }
        }
    }
}

