/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.Fleet;
import java.net.URI;

public class FleetCreator
extends Creator<Fleet> {
    private String networkAccessProfile;
    private String uniqueName;
    private Boolean dataEnabled;
    private Integer dataLimit;
    private URI ipCommandsUrl;
    private HttpMethod ipCommandsMethod;
    private Boolean smsCommandsEnabled;
    private URI smsCommandsUrl;
    private HttpMethod smsCommandsMethod;

    public FleetCreator(String networkAccessProfile) {
        this.networkAccessProfile = networkAccessProfile;
    }

    public FleetCreator setNetworkAccessProfile(String networkAccessProfile) {
        this.networkAccessProfile = networkAccessProfile;
        return this;
    }

    public FleetCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public FleetCreator setDataEnabled(Boolean dataEnabled) {
        this.dataEnabled = dataEnabled;
        return this;
    }

    public FleetCreator setDataLimit(Integer dataLimit) {
        this.dataLimit = dataLimit;
        return this;
    }

    public FleetCreator setIpCommandsUrl(URI ipCommandsUrl) {
        this.ipCommandsUrl = ipCommandsUrl;
        return this;
    }

    public FleetCreator setIpCommandsUrl(String ipCommandsUrl) {
        return this.setIpCommandsUrl(Promoter.uriFromString(ipCommandsUrl));
    }

    public FleetCreator setIpCommandsMethod(HttpMethod ipCommandsMethod) {
        this.ipCommandsMethod = ipCommandsMethod;
        return this;
    }

    public FleetCreator setSmsCommandsEnabled(Boolean smsCommandsEnabled) {
        this.smsCommandsEnabled = smsCommandsEnabled;
        return this;
    }

    public FleetCreator setSmsCommandsUrl(URI smsCommandsUrl) {
        this.smsCommandsUrl = smsCommandsUrl;
        return this;
    }

    public FleetCreator setSmsCommandsUrl(String smsCommandsUrl) {
        return this.setSmsCommandsUrl(Promoter.uriFromString(smsCommandsUrl));
    }

    public FleetCreator setSmsCommandsMethod(HttpMethod smsCommandsMethod) {
        this.smsCommandsMethod = smsCommandsMethod;
        return this;
    }

    @Override
    public Fleet create(TwilioRestClient client) {
        String path = "/v1/Fleets";
        path = path.replace("{NetworkAccessProfile}", this.networkAccessProfile.toString());
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Fleet creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Fleet.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.networkAccessProfile != null) {
            request.addPostParam("NetworkAccessProfile", this.networkAccessProfile);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.dataEnabled != null) {
            request.addPostParam("DataEnabled", this.dataEnabled.toString());
        }
        if (this.dataLimit != null) {
            request.addPostParam("DataLimit", this.dataLimit.toString());
        }
        if (this.ipCommandsUrl != null) {
            request.addPostParam("IpCommandsUrl", this.ipCommandsUrl.toString());
        }
        if (this.ipCommandsMethod != null) {
            request.addPostParam("IpCommandsMethod", this.ipCommandsMethod.toString());
        }
        if (this.smsCommandsEnabled != null) {
            request.addPostParam("SmsCommandsEnabled", this.smsCommandsEnabled.toString());
        }
        if (this.smsCommandsUrl != null) {
            request.addPostParam("SmsCommandsUrl", this.smsCommandsUrl.toString());
        }
        if (this.smsCommandsMethod != null) {
            request.addPostParam("SmsCommandsMethod", this.smsCommandsMethod.toString());
        }
    }
}

