/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.supersim.v1.FleetCreator;
import com.twilio.rest.supersim.v1.FleetFetcher;
import com.twilio.rest.supersim.v1.FleetReader;
import com.twilio.rest.supersim.v1.FleetUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Fleet
extends Resource {
    private static final long serialVersionUID = 74063802547191L;
    private final String accountSid;
    private final String sid;
    private final String uniqueName;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Boolean dataEnabled;
    private final Integer dataLimit;
    private final DataMetering dataMetering;
    private final Boolean smsCommandsEnabled;
    private final URI smsCommandsUrl;
    private final HttpMethod smsCommandsMethod;
    private final String networkAccessProfileSid;
    private final URI ipCommandsUrl;
    private final HttpMethod ipCommandsMethod;

    public static FleetCreator creator(String networkAccessProfile) {
        return new FleetCreator(networkAccessProfile);
    }

    public static FleetFetcher fetcher(String pathSid) {
        return new FleetFetcher(pathSid);
    }

    public static FleetReader reader() {
        return new FleetReader();
    }

    public static FleetUpdater updater(String pathSid) {
        return new FleetUpdater(pathSid);
    }

    public static Fleet fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Fleet.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Fleet fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Fleet.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Fleet(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="data_enabled") Boolean dataEnabled, @JsonProperty(value="data_limit") Integer dataLimit, @JsonProperty(value="data_metering") DataMetering dataMetering, @JsonProperty(value="sms_commands_enabled") Boolean smsCommandsEnabled, @JsonProperty(value="sms_commands_url") URI smsCommandsUrl, @JsonProperty(value="sms_commands_method") HttpMethod smsCommandsMethod, @JsonProperty(value="network_access_profile_sid") String networkAccessProfileSid, @JsonProperty(value="ip_commands_url") URI ipCommandsUrl, @JsonProperty(value="ip_commands_method") HttpMethod ipCommandsMethod) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.dataEnabled = dataEnabled;
        this.dataLimit = dataLimit;
        this.dataMetering = dataMetering;
        this.smsCommandsEnabled = smsCommandsEnabled;
        this.smsCommandsUrl = smsCommandsUrl;
        this.smsCommandsMethod = smsCommandsMethod;
        this.networkAccessProfileSid = networkAccessProfileSid;
        this.ipCommandsUrl = ipCommandsUrl;
        this.ipCommandsMethod = ipCommandsMethod;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Boolean getDataEnabled() {
        return this.dataEnabled;
    }

    public final Integer getDataLimit() {
        return this.dataLimit;
    }

    public final DataMetering getDataMetering() {
        return this.dataMetering;
    }

    public final Boolean getSmsCommandsEnabled() {
        return this.smsCommandsEnabled;
    }

    public final URI getSmsCommandsUrl() {
        return this.smsCommandsUrl;
    }

    public final HttpMethod getSmsCommandsMethod() {
        return this.smsCommandsMethod;
    }

    public final String getNetworkAccessProfileSid() {
        return this.networkAccessProfileSid;
    }

    public final URI getIpCommandsUrl() {
        return this.ipCommandsUrl;
    }

    public final HttpMethod getIpCommandsMethod() {
        return this.ipCommandsMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fleet other = (Fleet)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.dataEnabled, other.dataEnabled) && Objects.equals(this.dataLimit, other.dataLimit) && Objects.equals((Object)this.dataMetering, (Object)other.dataMetering) && Objects.equals(this.smsCommandsEnabled, other.smsCommandsEnabled) && Objects.equals(this.smsCommandsUrl, other.smsCommandsUrl) && Objects.equals((Object)this.smsCommandsMethod, (Object)other.smsCommandsMethod) && Objects.equals(this.networkAccessProfileSid, other.networkAccessProfileSid) && Objects.equals(this.ipCommandsUrl, other.ipCommandsUrl) && Objects.equals((Object)this.ipCommandsMethod, (Object)other.ipCommandsMethod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.sid, this.uniqueName, this.dateCreated, this.dateUpdated, this.url, this.dataEnabled, this.dataLimit, this.dataMetering, this.smsCommandsEnabled, this.smsCommandsUrl, this.smsCommandsMethod, this.networkAccessProfileSid, this.ipCommandsUrl, this.ipCommandsMethod});
    }

    public String toString() {
        return "Fleet(accountSid=" + this.getAccountSid() + ", sid=" + this.getSid() + ", uniqueName=" + this.getUniqueName() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", dataEnabled=" + this.getDataEnabled() + ", dataLimit=" + this.getDataLimit() + ", dataMetering=" + (Object)((Object)this.getDataMetering()) + ", smsCommandsEnabled=" + this.getSmsCommandsEnabled() + ", smsCommandsUrl=" + this.getSmsCommandsUrl() + ", smsCommandsMethod=" + (Object)((Object)this.getSmsCommandsMethod()) + ", networkAccessProfileSid=" + this.getNetworkAccessProfileSid() + ", ipCommandsUrl=" + this.getIpCommandsUrl() + ", ipCommandsMethod=" + (Object)((Object)this.getIpCommandsMethod()) + ")";
    }

    public static enum DataMetering {
        PAYG("payg");

        private final String value;

        private DataMetering(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static DataMetering forValue(String value) {
            return (DataMetering)Promoter.enumFromString((String)value, (Enum[])DataMetering.values());
        }
    }
}

