/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.EsimProfile;

public class EsimProfileReader
extends Reader<EsimProfile> {
    private String eid;
    private String simSid;
    private EsimProfile.Status status;
    private Integer pageSize;

    public EsimProfileReader setEid(String eid) {
        this.eid = eid;
        return this;
    }

    public EsimProfileReader setSimSid(String simSid) {
        this.simSid = simSid;
        return this;
    }

    public EsimProfileReader setStatus(EsimProfile.Status status) {
        this.status = status;
        return this;
    }

    public EsimProfileReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<EsimProfile> read(TwilioRestClient client) {
        return new ResourceSet<EsimProfile>(this, client, this.firstPage(client));
    }

    @Override
    public Page<EsimProfile> firstPage(TwilioRestClient client) {
        String path = "/v1/ESimProfiles";
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<EsimProfile> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("EsimProfile read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("esim_profiles", response.getContent(), EsimProfile.class, client.getObjectMapper());
    }

    @Override
    public Page<EsimProfile> previousPage(Page<EsimProfile> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<EsimProfile> nextPage(Page<EsimProfile> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<EsimProfile> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.eid != null) {
            request.addQueryParam("Eid", this.eid);
        }
        if (this.simSid != null) {
            request.addQueryParam("SimSid", this.simSid);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

