/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.EsimProfile;

public class EsimProfileCreator
extends Creator<EsimProfile> {
    private String callbackUrl;
    private HttpMethod callbackMethod;
    private Boolean generateMatchingId;
    private String eid;

    public EsimProfileCreator setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public EsimProfileCreator setCallbackMethod(HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public EsimProfileCreator setGenerateMatchingId(Boolean generateMatchingId) {
        this.generateMatchingId = generateMatchingId;
        return this;
    }

    public EsimProfileCreator setEid(String eid) {
        this.eid = eid;
        return this;
    }

    @Override
    public EsimProfile create(TwilioRestClient client) {
        String path = "/v1/ESimProfiles";
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("EsimProfile creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return EsimProfile.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl);
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod.toString());
        }
        if (this.generateMatchingId != null) {
            request.addPostParam("GenerateMatchingId", this.generateMatchingId.toString());
        }
        if (this.eid != null) {
            request.addPostParam("Eid", this.eid);
        }
    }
}

