/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v2.FlowValidateUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FlowValidate
extends Resource {
    private static final long serialVersionUID = 128242236604078L;
    private final Boolean valid;

    public static FlowValidateUpdater updater(String friendlyName, Status status, Map<String, Object> definition) {
        return new FlowValidateUpdater(friendlyName, status, definition);
    }

    public static FlowValidate fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FlowValidate.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FlowValidate fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FlowValidate.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FlowValidate(@JsonProperty(value="valid") Boolean valid) {
        this.valid = valid;
    }

    public final Boolean getValid() {
        return this.valid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowValidate other = (FlowValidate)o;
        return Objects.equals(this.valid, other.valid);
    }

    public int hashCode() {
        return Objects.hash(this.valid);
    }

    public String toString() {
        return "FlowValidate(valid=" + this.getValid() + ")";
    }

    public static enum Status {
        DRAFT("draft"),
        PUBLISHED("published");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

