/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow.engagement.step;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.engagement.step.StepContext;

public class StepContextFetcher
extends Fetcher<StepContext> {
    private String pathFlowSid;
    private String pathEngagementSid;
    private String pathStepSid;

    public StepContextFetcher(String pathFlowSid, String pathEngagementSid, String pathStepSid) {
        this.pathFlowSid = pathFlowSid;
        this.pathEngagementSid = pathEngagementSid;
        this.pathStepSid = pathStepSid;
    }

    @Override
    public StepContext fetch(TwilioRestClient client) {
        String path = "/v1/Flows/{FlowSid}/Engagements/{EngagementSid}/Steps/{StepSid}/Context";
        path = path.replace("{FlowSid}", this.pathFlowSid.toString());
        path = path.replace("{EngagementSid}", this.pathEngagementSid.toString());
        path = path.replace("{StepSid}", this.pathStepSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("StepContext fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return StepContext.fromJson(response.getStream(), client.getObjectMapper());
    }
}

