/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow.engagement;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.engagement.Step;

public class StepReader
extends Reader<Step> {
    private String pathFlowSid;
    private String pathEngagementSid;
    private Integer pageSize;

    public StepReader(String pathFlowSid, String pathEngagementSid) {
        this.pathFlowSid = pathFlowSid;
        this.pathEngagementSid = pathEngagementSid;
    }

    public StepReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Step> read(TwilioRestClient client) {
        return new ResourceSet<Step>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Step> firstPage(TwilioRestClient client) {
        String path = "/v1/Flows/{FlowSid}/Engagements/{EngagementSid}/Steps";
        path = path.replace("{FlowSid}", this.pathFlowSid.toString());
        path = path.replace("{EngagementSid}", this.pathEngagementSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Step> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Step read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("steps", response.getContent(), Step.class, client.getObjectMapper());
    }

    @Override
    public Page<Step> previousPage(Page<Step> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Step> nextPage(Page<Step> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Step> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

