/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.Execution;

public class ExecutionDeleter
extends Deleter<Execution> {
    private String pathFlowSid;
    private String pathSid;

    public ExecutionDeleter(String pathFlowSid, String pathSid) {
        this.pathFlowSid = pathFlowSid;
        this.pathSid = pathSid;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        String path = "/v1/Flows/{FlowSid}/Executions/{Sid}";
        path = path.replace("{FlowSid}", this.pathFlowSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.DELETE, Domains.STUDIO.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Execution delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }
}

