/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.Engagement;
import com.twilio.type.PhoneNumber;
import java.util.Map;

public class EngagementCreator
extends Creator<Engagement> {
    private String pathFlowSid;
    private PhoneNumber to;
    private PhoneNumber from;
    private Map<String, Object> parameters;

    public EngagementCreator(String pathFlowSid, PhoneNumber to, PhoneNumber from) {
        this.pathFlowSid = pathFlowSid;
        this.to = to;
        this.from = from;
    }

    public EngagementCreator setTo(PhoneNumber to) {
        this.to = to;
        return this;
    }

    public EngagementCreator setTo(String to) {
        return this.setTo(Promoter.phoneNumberFromString(to));
    }

    public EngagementCreator setFrom(PhoneNumber from) {
        this.from = from;
        return this;
    }

    public EngagementCreator setFrom(String from) {
        return this.setFrom(Promoter.phoneNumberFromString(from));
    }

    public EngagementCreator setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public Engagement create(TwilioRestClient client) {
        String path = "/v1/Flows/{FlowSid}/Engagements";
        path = path.replace("{FlowSid}", this.pathFlowSid.toString());
        path = path.replace("{To}", this.to.encode("utf-8"));
        path = path.replace("{From}", this.from.encode("utf-8"));
        Request request = new Request(HttpMethod.POST, Domains.STUDIO.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Engagement creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Engagement.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.to != null) {
            request.addPostParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addPostParam("From", this.from.toString());
        }
        if (this.parameters != null) {
            request.addPostParam("Parameters", Converter.mapToJson(this.parameters));
        }
    }
}

