/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.Flow;

public class FlowFetcher
extends Fetcher<Flow> {
    private String pathSid;

    public FlowFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public Flow fetch(TwilioRestClient client) {
        String path = "/v1/Flows/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Flow fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Flow.fromJson(response.getStream(), client.getObjectMapper());
    }
}

