/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.function.functionversion;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.function.functionversion.FunctionVersionContent;

public class FunctionVersionContentFetcher
extends Fetcher<FunctionVersionContent> {
    private String pathServiceSid;
    private String pathFunctionSid;
    private String pathSid;

    public FunctionVersionContentFetcher(String pathServiceSid, String pathFunctionSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathFunctionSid = pathFunctionSid;
        this.pathSid = pathSid;
    }

    @Override
    public FunctionVersionContent fetch(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Functions/{FunctionSid}/Versions/{Sid}/Content";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{FunctionSid}", this.pathFunctionSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.SERVERLESS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FunctionVersionContent fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return FunctionVersionContent.fromJson(response.getStream(), client.getObjectMapper());
    }
}

