/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.environment;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.environment.Variable;

public class VariableUpdater
extends Updater<Variable> {
    private String pathServiceSid;
    private String pathEnvironmentSid;
    private String pathSid;
    private String key;
    private String value;

    public VariableUpdater(String pathServiceSid, String pathEnvironmentSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathEnvironmentSid = pathEnvironmentSid;
        this.pathSid = pathSid;
    }

    public VariableUpdater setKey(String key) {
        this.key = key;
        return this;
    }

    public VariableUpdater setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public Variable update(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Environments/{EnvironmentSid}/Variables/{Sid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{EnvironmentSid}", this.pathEnvironmentSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.SERVERLESS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Variable update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Variable.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.key != null) {
            request.addPostParam("Key", this.key);
        }
        if (this.value != null) {
            request.addPostParam("Value", this.value);
        }
    }
}

