/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.environment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.serverless.v1.service.environment.LogFetcher;
import com.twilio.rest.serverless.v1.service.environment.LogReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Log
extends Resource {
    private static final long serialVersionUID = 129897058125132L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String environmentSid;
    private final String buildSid;
    private final String deploymentSid;
    private final String functionSid;
    private final String requestSid;
    private final Level level;
    private final String message;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static LogFetcher fetcher(String pathServiceSid, String pathEnvironmentSid, String pathSid) {
        return new LogFetcher(pathServiceSid, pathEnvironmentSid, pathSid);
    }

    public static LogReader reader(String pathServiceSid, String pathEnvironmentSid) {
        return new LogReader(pathServiceSid, pathEnvironmentSid);
    }

    public static Log fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Log.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Log fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Log.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Log(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="environment_sid") String environmentSid, @JsonProperty(value="build_sid") String buildSid, @JsonProperty(value="deployment_sid") String deploymentSid, @JsonProperty(value="function_sid") String functionSid, @JsonProperty(value="request_sid") String requestSid, @JsonProperty(value="level") Level level, @JsonProperty(value="message") String message, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.environmentSid = environmentSid;
        this.buildSid = buildSid;
        this.deploymentSid = deploymentSid;
        this.functionSid = functionSid;
        this.requestSid = requestSid;
        this.level = level;
        this.message = message;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getEnvironmentSid() {
        return this.environmentSid;
    }

    public final String getBuildSid() {
        return this.buildSid;
    }

    public final String getDeploymentSid() {
        return this.deploymentSid;
    }

    public final String getFunctionSid() {
        return this.functionSid;
    }

    public final String getRequestSid() {
        return this.requestSid;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final String getMessage() {
        return this.message;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Log other = (Log)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.environmentSid, other.environmentSid) && Objects.equals(this.buildSid, other.buildSid) && Objects.equals(this.deploymentSid, other.deploymentSid) && Objects.equals(this.functionSid, other.functionSid) && Objects.equals(this.requestSid, other.requestSid) && Objects.equals((Object)this.level, (Object)other.level) && Objects.equals(this.message, other.message) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.environmentSid, this.buildSid, this.deploymentSid, this.functionSid, this.requestSid, this.level, this.message, this.dateCreated, this.url});
    }

    public String toString() {
        return "Log(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", environmentSid=" + this.getEnvironmentSid() + ", buildSid=" + this.getBuildSid() + ", deploymentSid=" + this.getDeploymentSid() + ", functionSid=" + this.getFunctionSid() + ", requestSid=" + this.getRequestSid() + ", level=" + (Object)((Object)this.getLevel()) + ", message=" + this.getMessage() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Level {
        INFO("info"),
        WARN("warn"),
        ERROR("error");

        private final String value;

        private Level(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Level forValue(String value) {
            return (Level)Promoter.enumFromString((String)value, (Enum[])Level.values());
        }
    }
}

