/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.serverless.v1.service.EnvironmentCreator;
import com.twilio.rest.serverless.v1.service.EnvironmentDeleter;
import com.twilio.rest.serverless.v1.service.EnvironmentFetcher;
import com.twilio.rest.serverless.v1.service.EnvironmentReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Environment
extends Resource {
    private static final long serialVersionUID = 36784486672291L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String buildSid;
    private final String uniqueName;
    private final String domainSuffix;
    private final String domainName;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static EnvironmentCreator creator(String pathServiceSid, String uniqueName) {
        return new EnvironmentCreator(pathServiceSid, uniqueName);
    }

    public static EnvironmentDeleter deleter(String pathServiceSid, String pathSid) {
        return new EnvironmentDeleter(pathServiceSid, pathSid);
    }

    public static EnvironmentFetcher fetcher(String pathServiceSid, String pathSid) {
        return new EnvironmentFetcher(pathServiceSid, pathSid);
    }

    public static EnvironmentReader reader(String pathServiceSid) {
        return new EnvironmentReader(pathServiceSid);
    }

    public static Environment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Environment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Environment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Environment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Environment(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="build_sid") String buildSid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="domain_suffix") String domainSuffix, @JsonProperty(value="domain_name") String domainName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.buildSid = buildSid;
        this.uniqueName = uniqueName;
        this.domainSuffix = domainSuffix;
        this.domainName = domainName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getBuildSid() {
        return this.buildSid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getDomainSuffix() {
        return this.domainSuffix;
    }

    public final String getDomainName() {
        return this.domainName;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment other = (Environment)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.buildSid, other.buildSid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.domainSuffix, other.domainSuffix) && Objects.equals(this.domainName, other.domainName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.buildSid, this.uniqueName, this.domainSuffix, this.domainName, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return "Environment(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", buildSid=" + this.getBuildSid() + ", uniqueName=" + this.getUniqueName() + ", domainSuffix=" + this.getDomainSuffix() + ", domainName=" + this.getDomainName() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }
}

