/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.Service;

public class ServiceUpdater
extends Updater<Service> {
    private String pathSid;
    private Boolean includeCredentials;
    private String friendlyName;
    private Boolean uiEditable;

    public ServiceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ServiceUpdater setIncludeCredentials(Boolean includeCredentials) {
        this.includeCredentials = includeCredentials;
        return this;
    }

    public ServiceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceUpdater setUiEditable(Boolean uiEditable) {
        this.uiEditable = uiEditable;
        return this;
    }

    @Override
    public Service update(TwilioRestClient client) {
        String path = "/v1/Services/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.SERVERLESS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.includeCredentials != null) {
            request.addPostParam("IncludeCredentials", this.includeCredentials.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uiEditable != null) {
            request.addPostParam("UiEditable", this.uiEditable.toString());
        }
    }
}

