/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service.session;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.session.Interaction;

public class InteractionReader
extends Reader<Interaction> {
    private String pathServiceSid;
    private String pathSessionSid;
    private Integer pageSize;

    public InteractionReader(String pathServiceSid, String pathSessionSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSessionSid = pathSessionSid;
    }

    public InteractionReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Interaction> read(TwilioRestClient client) {
        return new ResourceSet<Interaction>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Interaction> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Sessions/{SessionSid}/Interactions";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{SessionSid}", this.pathSessionSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.PROXY.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Interaction> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Interaction read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("interactions", response.getContent(), Interaction.class, client.getObjectMapper());
    }

    @Override
    public Page<Interaction> previousPage(Page<Interaction> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PROXY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Interaction> nextPage(Page<Interaction> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PROXY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Interaction> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

