/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewmessaging.v1;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.previewmessaging.v1.Broadcast;
import java.util.UUID;

public class BroadcastCreator
extends Creator<Broadcast> {
    private UUID xTwilioRequestKey;

    public BroadcastCreator setXTwilioRequestKey(UUID xTwilioRequestKey) {
        this.xTwilioRequestKey = xTwilioRequestKey;
        return this;
    }

    @Override
    public Broadcast create(TwilioRestClient client) {
        String path = "/v1/Broadcasts";
        Request request = new Request(HttpMethod.POST, Domains.PREVIEWMESSAGING.toString(), path);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Broadcast creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Broadcast.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioRequestKey != null) {
            request.addHeaderParam("X-Twilio-Request-Key", this.xTwilioRequestKey.toString());
        }
    }
}

