/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.syncmap;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.syncmap.SyncMapPermission;

public class SyncMapPermissionUpdater
extends Updater<SyncMapPermission> {
    private String pathServiceSid;
    private String pathMapSid;
    private String pathIdentity;
    private Boolean read;
    private Boolean write;
    private Boolean manage;

    public SyncMapPermissionUpdater(String pathServiceSid, String pathMapSid, String pathIdentity, Boolean read, Boolean write, Boolean manage) {
        this.pathServiceSid = pathServiceSid;
        this.pathMapSid = pathMapSid;
        this.pathIdentity = pathIdentity;
        this.read = read;
        this.write = write;
        this.manage = manage;
    }

    public SyncMapPermissionUpdater setRead(Boolean read) {
        this.read = read;
        return this;
    }

    public SyncMapPermissionUpdater setWrite(Boolean write) {
        this.write = write;
        return this;
    }

    public SyncMapPermissionUpdater setManage(Boolean manage) {
        this.manage = manage;
        return this;
    }

    @Override
    public SyncMapPermission update(TwilioRestClient client) {
        String path = "/Sync/Services/{ServiceSid}/Maps/{MapSid}/Permissions/{Identity}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{MapSid}", this.pathMapSid.toString());
        path = path.replace("{Identity}", this.pathIdentity.toString());
        path = path.replace("{Read}", this.read.toString());
        path = path.replace("{Write}", this.write.toString());
        path = path.replace("{Manage}", this.manage.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncMapPermission update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SyncMapPermission.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.read != null) {
            request.addPostParam("Read", this.read.toString());
        }
        if (this.write != null) {
            request.addPostParam("Write", this.write.toString());
        }
        if (this.manage != null) {
            request.addPostParam("Manage", this.manage.toString());
        }
    }
}

