/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.syncmap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.sync.service.syncmap.SyncMapItemCreator;
import com.twilio.rest.preview.sync.service.syncmap.SyncMapItemDeleter;
import com.twilio.rest.preview.sync.service.syncmap.SyncMapItemFetcher;
import com.twilio.rest.preview.sync.service.syncmap.SyncMapItemReader;
import com.twilio.rest.preview.sync.service.syncmap.SyncMapItemUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SyncMapItem
extends Resource {
    private static final long serialVersionUID = 40990956939472L;
    private final String key;
    private final String accountSid;
    private final String serviceSid;
    private final String mapSid;
    private final URI url;
    private final String revision;
    private final Map<String, Object> data;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String createdBy;

    public static SyncMapItemCreator creator(String pathServiceSid, String pathMapSid, String key, Map<String, Object> data) {
        return new SyncMapItemCreator(pathServiceSid, pathMapSid, key, data);
    }

    public static SyncMapItemDeleter deleter(String pathServiceSid, String pathMapSid, String pathKey) {
        return new SyncMapItemDeleter(pathServiceSid, pathMapSid, pathKey);
    }

    public static SyncMapItemFetcher fetcher(String pathServiceSid, String pathMapSid, String pathKey) {
        return new SyncMapItemFetcher(pathServiceSid, pathMapSid, pathKey);
    }

    public static SyncMapItemReader reader(String pathServiceSid, String pathMapSid) {
        return new SyncMapItemReader(pathServiceSid, pathMapSid);
    }

    public static SyncMapItemUpdater updater(String pathServiceSid, String pathMapSid, String pathKey, Map<String, Object> data) {
        return new SyncMapItemUpdater(pathServiceSid, pathMapSid, pathKey, data);
    }

    public static SyncMapItem fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SyncMapItem.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SyncMapItem fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SyncMapItem.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SyncMapItem(@JsonProperty(value="key") String key, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="map_sid") String mapSid, @JsonProperty(value="url") URI url, @JsonProperty(value="revision") String revision, @JsonProperty(value="data") Map<String, Object> data, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="created_by") String createdBy) {
        this.key = key;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.mapSid = mapSid;
        this.url = url;
        this.revision = revision;
        this.data = data;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.createdBy = createdBy;
    }

    public final String getKey() {
        return this.key;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getMapSid() {
        return this.mapSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getRevision() {
        return this.revision;
    }

    public final Map<String, Object> getData() {
        return this.data;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getCreatedBy() {
        return this.createdBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncMapItem other = (SyncMapItem)o;
        return Objects.equals(this.key, other.key) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.mapSid, other.mapSid) && Objects.equals(this.url, other.url) && Objects.equals(this.revision, other.revision) && Objects.equals(this.data, other.data) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.createdBy, other.createdBy);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.accountSid, this.serviceSid, this.mapSid, this.url, this.revision, this.data, this.dateCreated, this.dateUpdated, this.createdBy);
    }

    public String toString() {
        return "SyncMapItem(key=" + this.getKey() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", mapSid=" + this.getMapSid() + ", url=" + this.getUrl() + ", revision=" + this.getRevision() + ", data=" + this.getData() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", createdBy=" + this.getCreatedBy() + ")";
    }

    public static enum QueryResultOrder {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private QueryResultOrder(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static QueryResultOrder forValue(String value) {
            return (QueryResultOrder)Promoter.enumFromString((String)value, (Enum[])QueryResultOrder.values());
        }
    }

    public static enum QueryFromBoundType {
        INCLUSIVE("inclusive"),
        EXCLUSIVE("exclusive");

        private final String value;

        private QueryFromBoundType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static QueryFromBoundType forValue(String value) {
            return (QueryFromBoundType)Promoter.enumFromString((String)value, (Enum[])QueryFromBoundType.values());
        }
    }
}

