/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.document;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.document.DocumentPermission;

public class DocumentPermissionUpdater
extends Updater<DocumentPermission> {
    private String pathServiceSid;
    private String pathDocumentSid;
    private String pathIdentity;
    private Boolean read;
    private Boolean write;
    private Boolean manage;

    public DocumentPermissionUpdater(String pathServiceSid, String pathDocumentSid, String pathIdentity, Boolean read, Boolean write, Boolean manage) {
        this.pathServiceSid = pathServiceSid;
        this.pathDocumentSid = pathDocumentSid;
        this.pathIdentity = pathIdentity;
        this.read = read;
        this.write = write;
        this.manage = manage;
    }

    public DocumentPermissionUpdater setRead(Boolean read) {
        this.read = read;
        return this;
    }

    public DocumentPermissionUpdater setWrite(Boolean write) {
        this.write = write;
        return this;
    }

    public DocumentPermissionUpdater setManage(Boolean manage) {
        this.manage = manage;
        return this;
    }

    @Override
    public DocumentPermission update(TwilioRestClient client) {
        String path = "/Sync/Services/{ServiceSid}/Documents/{DocumentSid}/Permissions/{Identity}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{DocumentSid}", this.pathDocumentSid.toString());
        path = path.replace("{Identity}", this.pathIdentity.toString());
        path = path.replace("{Read}", this.read.toString());
        path = path.replace("{Write}", this.write.toString());
        path = path.replace("{Manage}", this.manage.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DocumentPermission update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return DocumentPermission.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.read != null) {
            request.addPostParam("Read", this.read.toString());
        }
        if (this.write != null) {
            request.addPostParam("Write", this.write.toString());
        }
        if (this.manage != null) {
            request.addPostParam("Manage", this.manage.toString());
        }
    }
}

