/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.marketplace;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.marketplace.InstalledAddOn;
import java.util.Map;

public class InstalledAddOnUpdater
extends Updater<InstalledAddOn> {
    private String pathSid;
    private Map<String, Object> configuration;
    private String uniqueName;

    public InstalledAddOnUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public InstalledAddOnUpdater setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
        return this;
    }

    public InstalledAddOnUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    @Override
    public InstalledAddOn update(TwilioRestClient client) {
        String path = "/marketplace/InstalledAddOns/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InstalledAddOn update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InstalledAddOn.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.configuration != null) {
            request.addPostParam("Configuration", Converter.mapToJson(this.configuration));
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
    }
}

