/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.deployedDevices.fleet.KeyCreator;
import com.twilio.rest.preview.deployedDevices.fleet.KeyDeleter;
import com.twilio.rest.preview.deployedDevices.fleet.KeyFetcher;
import com.twilio.rest.preview.deployedDevices.fleet.KeyReader;
import com.twilio.rest.preview.deployedDevices.fleet.KeyUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Key
extends Resource {
    private static final long serialVersionUID = 158435998679490L;
    private final String sid;
    private final URI url;
    private final String friendlyName;
    private final String fleetSid;
    private final String accountSid;
    private final String deviceSid;
    private final String secret;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    public static KeyCreator creator(String pathFleetSid) {
        return new KeyCreator(pathFleetSid);
    }

    public static KeyDeleter deleter(String pathFleetSid, String pathSid) {
        return new KeyDeleter(pathFleetSid, pathSid);
    }

    public static KeyFetcher fetcher(String pathFleetSid, String pathSid) {
        return new KeyFetcher(pathFleetSid, pathSid);
    }

    public static KeyReader reader(String pathFleetSid) {
        return new KeyReader(pathFleetSid);
    }

    public static KeyUpdater updater(String pathFleetSid, String pathSid) {
        return new KeyUpdater(pathFleetSid, pathSid);
    }

    public static Key fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Key.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Key fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Key.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Key(@JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="fleet_sid") String fleetSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="device_sid") String deviceSid, @JsonProperty(value="secret") String secret, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sid = sid;
        this.url = url;
        this.friendlyName = friendlyName;
        this.fleetSid = fleetSid;
        this.accountSid = accountSid;
        this.deviceSid = deviceSid;
        this.secret = secret;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getFleetSid() {
        return this.fleetSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getDeviceSid() {
        return this.deviceSid;
    }

    public final String getSecret() {
        return this.secret;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key other = (Key)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.fleetSid, other.fleetSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.deviceSid, other.deviceSid) && Objects.equals(this.secret, other.secret) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.url, this.friendlyName, this.fleetSid, this.accountSid, this.deviceSid, this.secret, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return "Key(sid=" + this.getSid() + ", url=" + this.getUrl() + ", friendlyName=" + this.getFriendlyName() + ", fleetSid=" + this.getFleetSid() + ", accountSid=" + this.getAccountSid() + ", deviceSid=" + this.getDeviceSid() + ", secret=" + this.getSecret() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ")";
    }
}

