/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.deployedDevices.fleet.Certificate;

public class CertificateCreator
extends Creator<Certificate> {
    private String pathFleetSid;
    private String certificateData;
    private String friendlyName;
    private String deviceSid;

    public CertificateCreator(String pathFleetSid, String certificateData) {
        this.pathFleetSid = pathFleetSid;
        this.certificateData = certificateData;
    }

    public CertificateCreator setCertificateData(String certificateData) {
        this.certificateData = certificateData;
        return this;
    }

    public CertificateCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public CertificateCreator setDeviceSid(String deviceSid) {
        this.deviceSid = deviceSid;
        return this;
    }

    @Override
    public Certificate create(TwilioRestClient client) {
        String path = "/DeployedDevices/Fleets/{FleetSid}/Certificates";
        path = path.replace("{FleetSid}", this.pathFleetSid.toString());
        path = path.replace("{CertificateData}", this.certificateData.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Certificate creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Certificate.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.certificateData != null) {
            request.addPostParam("CertificateData", this.certificateData);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.deviceSid != null) {
            request.addPostParam("DeviceSid", this.deviceSid);
        }
    }
}

