/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.deployedDevices.Fleet;

public class FleetUpdater
extends Updater<Fleet> {
    private String pathSid;
    private String friendlyName;
    private String defaultDeploymentSid;

    public FleetUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public FleetUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public FleetUpdater setDefaultDeploymentSid(String defaultDeploymentSid) {
        this.defaultDeploymentSid = defaultDeploymentSid;
        return this;
    }

    @Override
    public Fleet update(TwilioRestClient client) {
        String path = "/DeployedDevices/Fleets/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Fleet update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Fleet.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.defaultDeploymentSid != null) {
            request.addPostParam("DefaultDeploymentSid", this.defaultDeploymentSid);
        }
    }
}

